/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.objmgr.lpar;

import com.ibm.hsc.common.exceptions.PIHscCmdMgrException;
import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.fsp.FSPCmdMgr;
import com.ibm.hsc.fsp.cmdhelpers.FspCmdHelper;
import com.ibm.hsc.fsp.cmdhelpers.FspLparAttributes;
import com.ibm.hsc.fsp.cmdhelpers.FspLparVioSlotStates;
import com.ibm.hsc.fsp.cmdhelpers.VioSlotState;
import com.ibm.hsc.objmgr.cec.OmCecMgr;
import com.ibm.hsc.objmgr.lpar.OmLparInstUpdater;
import com.ibm.hsc.objmgr.lpar.OmLparProfsUpdater;
import com.ibm.hsc.objmgr.lpar.OmLparVethUpdater;
import com.ibm.hsc.objmgr.lpar.OmLparVscsiUpdater;
import com.ibm.hsc.objmgr.lpar.OmLparVserialUpdater;
import com.ibm.hsc.objmgr.prof.OmProfMgr;
import com.ibm.hsc.rep.RException;
import com.ibm.hsc.rep.RObject;
import com.ibm.hsc.rep.RObjectId;
import com.ibm.hsc.rep.v50.R50ComputerSystem;
import com.ibm.hsc.rep.v50.R50Define;
import com.ibm.hsc.rep.v50.R50IOFailOverPool;
import com.ibm.hsc.rep.v50.R50Partition;
import com.ibm.hsc.rep.v50.R50WLMCluster;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;

public class OmLparMgr {
    private OmCecMgr mCecMgr;
    private RObjectId mLparOid;
    private RObject mLparObj;
    private OmLparInstUpdater mLparInstUpdater;
    private OmLparVethUpdater mLparVethUpdater;
    private OmLparVscsiUpdater mLparVscsiUpdater;
    private OmLparVserialUpdater mLparVserialUpdater;
    private OmLparProfsUpdater mLparProfsUpdater;
    private String mLparName;
    private int mLparIndex;
    private UnsignedInt16 mLparIndexUInt16;
    private FSPCmdMgr mCmdMgr;
    private FspCmdHelper mCmdHelper;
    private boolean mSentCreationEvent = false;

    private OmLparMgr(OmCecMgr omCecMgr, String string) throws RException, PIHscCmdMgrException {
        this.mCecMgr = omCecMgr;
        this.mLparName = string;
        this.mLparOid = new RObjectId(1, R50Define.CID_IBMHSC_Partition);
        this.mLparOid.setKeyValue(0, this.mLparName);
        this.mLparOid.setKeyValue(1, "IBMHSC_Partition");
        this.mLparObj = this.mLparOid.getObject();
        if (this.mLparObj == null) {
            this.mLparObj = new RObject(this.mLparOid);
            this.mLparObj.addInstance();
            this.mLparObj.addAssociation(R50Define.AID_IBMHSC_CompSysPartition, this.mCecMgr.getObjectId());
        }
        this.mLparIndex = Integer.parseInt(this.mLparName.substring(0, this.mLparName.indexOf("*")));
        this.mLparIndexUInt16 = new UnsignedInt16(this.mLparIndex);
        this.mCmdMgr = this.mCecMgr.getCmdMgr();
        this.mCmdHelper = this.mCecMgr.getCmdHelper();
    }

    public OmLparInstUpdater getLparInstUpdater() {
        if (this.mLparInstUpdater == null) {
            this.mLparInstUpdater = new OmLparInstUpdater(this);
        }
        return this.mLparInstUpdater;
    }

    public OmLparVethUpdater getLparVethUpdater() {
        if (this.mLparVethUpdater == null) {
            this.mLparVethUpdater = new OmLparVethUpdater(this);
        }
        return this.mLparVethUpdater;
    }

    public OmLparVscsiUpdater getLparVscsiUpdater() {
        if (this.mLparVscsiUpdater == null) {
            this.mLparVscsiUpdater = new OmLparVscsiUpdater(this);
        }
        return this.mLparVscsiUpdater;
    }

    public OmLparVserialUpdater getLparVserialUpdater() {
        if (this.mLparVserialUpdater == null) {
            this.mLparVserialUpdater = new OmLparVserialUpdater(this);
        }
        return this.mLparVserialUpdater;
    }

    public OmLparProfsUpdater getLparProfsUpdater() {
        if (this.mLparProfsUpdater == null) {
            this.mLparProfsUpdater = new OmLparProfsUpdater(this);
        }
        return this.mLparProfsUpdater;
    }

    public static OmLparMgr getLparMgr(OmCecMgr omCecMgr, String string) throws RException {
        OmLparMgr omLparMgr = omCecMgr.getLparMgr(string);
        return omLparMgr;
    }

    public static OmLparMgr createLparMgr(OmCecMgr omCecMgr, String string) throws RException, PIHscCmdMgrException {
        return OmLparMgr.createLparMgr(omCecMgr, string, null);
    }

    public static OmLparMgr createLparMgr(OmCecMgr omCecMgr, String string, String string2) throws RException, PIHscCmdMgrException {
        System.out.println("[OM] createLparMgr");
        OmLparMgr omLparMgr = omCecMgr.getLparMgr(string);
        if (omLparMgr == null) {
            omLparMgr = new OmLparMgr(omCecMgr, string);
            if (string2 != null) {
                omLparMgr.setProperty(R50Partition.Index_UserDefinedName, (Object)string2);
            }
        } else {
            System.out.println("PARTITION ALREADY EXISTS");
        }
        return omLparMgr;
    }

    public void setInitState() throws RException {
        int n = this.mCecMgr.getSaveArea().getPartitionOsType(this.getLparIndex());
        System.out.println("osType=" + n);
        int n2 = 0;
        if (n == 1) {
            n2 = 1;
        } else if (n == 129) {
            n2 = 129;
        } else if (n == 4) {
            n2 = 65;
        } else if (n == 65) {
            n2 = 3;
        } else {
            System.out.println("Error: invalid partition type");
        }
        System.out.println("defState=" + n2);
        this.mLparObj.setProperty(R50Partition.Index_DefinitionState, (Object)new UnsignedInt8((short)n2));
        this.mLparObj.setProperty(R50Partition.Index_PartitionState, (Object)new UnsignedInt8(252));
    }

    public OmProfMgr getProfMgr(String string) throws RException {
        return OmProfMgr.getProfMgr(this, string);
    }

    public void deleteProf(String string, boolean bl) throws RException, PIHscServerException {
        System.out.println("TONY: deleteProf");
        OmProfMgr omProfMgr = this.getProfMgr(string);
        omProfMgr.deleteProf(bl);
        System.out.println("TONY: profile deleted: " + string);
    }

    public void deleteAllProfs(boolean bl) throws RException, PIHscServerException {
        System.out.println("TONY: deleteAllProfs");
        Vector vector = this.mLparObj.associators(R50Define.AID_IBMHSC_PartitionProfile);
        if (vector != null) {
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                RObject rObject = (RObject)iterator.next();
                String string = (String)rObject.getProperty("SettingID");
                System.out.println("TONY: try to delete profile: " + string);
                this.deleteProf(string, bl);
            }
        }
    }

    public RObjectId getObjectId() {
        return this.mLparOid;
    }

    public RObject getObject() {
        return this.mLparObj;
    }

    public String getLparName() {
        return this.mLparName;
    }

    public int getLparIndex() {
        return this.mLparIndex;
    }

    public OmCecMgr getCecMgr() {
        return this.mCecMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLparAll() throws RException, PIHscServerException, PIHscCmdMgrException {
        boolean bl = false;
        RObject rObject = (RObject)this.mLparObj.clone();
        try {
            this.updateLparProfs();
            bl = this.updateLparInstance();
            if (this.mCecMgr.isHypervisorRunning()) {
                if (this.updateServiceAuthority(false)) {
                    bl = true;
                }
                this.updateLparVirtualIo();
                this.updateLparClusterGroup();
                this.updateLparIoPool();
            }
            Object var4_3 = null;
            if (!this.mSentCreationEvent) {
                this.mCecMgr.getIndMgr().sendIndication(1, this.mLparObj, null);
                this.mSentCreationEvent = true;
            } else if (bl) {
                this.mCecMgr.getIndMgr().sendIndication(4, this.mLparObj, rObject);
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!this.mSentCreationEvent) {
                this.mCecMgr.getIndMgr().sendIndication(1, this.mLparObj, null);
                this.mSentCreationEvent = true;
            } else if (bl) {
                this.mCecMgr.getIndMgr().sendIndication(4, this.mLparObj, rObject);
            }
            throw throwable;
        }
    }

    public void setSentCreationEvent() {
        this.mSentCreationEvent = true;
    }

    public boolean updateLparInstance() throws RException, PIHscServerException, PIHscCmdMgrException {
        return this.getLparInstUpdater().update();
    }

    public void updateLparProfs() throws RException, PIHscServerException {
        this.getLparProfsUpdater().update();
    }

    public void deleteLpar(boolean bl) throws PIHscServerException {
        if (bl) {
            this.mCecMgr.getSaveArea().setDefaultLPARProfile(this.mLparIndex, 0);
            this.mCecMgr.getSaveArea().setPartitionName(this.mLparIndex, new String(new byte[32]));
        }
        try {
            RObject rObject;
            Object object;
            Cloneable cloneable;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            this.deleteAllProfs(bl);
            Vector vector = this.mLparObj.associators(R50Define.AID_IBMHSC_LparVirtualEthernet);
            if (vector != null) {
                object5 = vector.elements();
                while (object5.hasMoreElements()) {
                    object4 = (RObject)object5.nextElement();
                    this.getLparVethUpdater().deleteVeth((RObject)object4);
                }
            }
            if ((object5 = this.mLparObj.associators(R50Define.AID_IBMHSC_LparVirtualSCSI)) != null) {
                object4 = ((Vector)object5).elements();
                while (object4.hasMoreElements()) {
                    object3 = (RObject)object4.nextElement();
                    this.getLparVscsiUpdater().deleteVscsi((RObject)object3);
                }
            }
            if ((object4 = this.mLparObj.associators(R50Define.AID_IBMHSC_LparVirtualSerial)) != null) {
                object3 = ((Vector)object4).elements();
                while (object3.hasMoreElements()) {
                    object2 = (RObject)object3.nextElement();
                    this.getLparVserialUpdater().deleteVserial((RObject)object2);
                }
            }
            object3 = this.mLparObj.associatorNames(R50Define.AID_IBMHSC_LparInIOFailOverPool);
            this.mLparObj.deleteAssociations(R50Define.AID_IBMHSC_LparInIOFailOverPool);
            if (object3 != null && (object2 = ((Vector)object3).elements()).hasMoreElements() && !((RObject)(cloneable = ((RObjectId)(object = (RObjectId)object2.nextElement())).getObject())).hasAssociation(R50Define.AID_IBMHSC_LparInIOFailOverPool)) {
                ((RObject)cloneable).deleteInstance();
            }
            object2 = this.mLparObj.associatorNames(R50Define.AID_IBMHSC_LparInWLMCluster);
            this.mLparObj.deleteAssociations(R50Define.AID_IBMHSC_LparInWLMCluster);
            if (object2 != null && (object = ((Vector)object2).elements()).hasMoreElements() && !(rObject = ((RObjectId)(cloneable = (RObjectId)object.nextElement())).getObject()).hasAssociation(R50Define.AID_IBMHSC_LparInWLMCluster)) {
                rObject.deleteInstance();
            }
            this.mLparObj.deleteInstance();
            this.mCecMgr.deleteLparMgr(this.mLparName);
            this.mCecMgr.getIndMgr().sendIndication(2, this.mLparObj, null);
        }
        catch (RException rException) {
            rException.printStackTrace();
            String[] stringArray = new String[]{this.mLparName};
            throw new PIHscServerException("05EC", stringArray, rException);
        }
    }

    public void updateLparVirtualIo() throws RException, PIHscServerException, PIHscCmdMgrException {
        UnsignedInt16 unsignedInt16 = (UnsignedInt16)this.mLparObj.getProperty(R50Partition.Index_PendMaxVirtualIOSlots);
        UnsignedInt16 unsignedInt162 = new UnsignedInt16(0);
        FspLparVioSlotStates fspLparVioSlotStates = this.mCmdHelper.getFspLparVioSlotStates(this.mLparIndexUInt16, unsignedInt162, unsignedInt16);
        System.out.println("fspVioStates = " + fspLparVioSlotStates);
        VioSlotState[] vioSlotStateArray = fspLparVioSlotStates.getVioSlotStates();
        Hashtable<UnsignedInt16, VioSlotState> hashtable = new Hashtable<UnsignedInt16, VioSlotState>();
        Hashtable<UnsignedInt16, VioSlotState> hashtable2 = new Hashtable<UnsignedInt16, VioSlotState>();
        Hashtable<UnsignedInt16, VioSlotState> hashtable3 = new Hashtable<UnsignedInt16, VioSlotState>();
        for (int i = 0; i < vioSlotStateArray.length; ++i) {
            VioSlotState vioSlotState = vioSlotStateArray[i];
            if (vioSlotState.slotState.intValue() == 1) {
                hashtable.put(vioSlotState.slotNumber, vioSlotState);
                continue;
            }
            if (vioSlotState.slotState.intValue() == 2) {
                hashtable2.put(vioSlotState.slotNumber, vioSlotState);
                continue;
            }
            if (vioSlotState.slotState.intValue() != 3) continue;
            hashtable3.put(vioSlotState.slotNumber, vioSlotState);
        }
        this.getLparVethUpdater().update(hashtable);
        this.getLparVscsiUpdater().update(hashtable2);
        this.getLparVserialUpdater().update(hashtable3);
    }

    public void updateLparClusterGroup() throws RException, PIHscServerException, PIHscCmdMgrException {
        Object object;
        System.out.println("[OM] updateLparClusterGroup: " + this.mLparName);
        FspLparAttributes fspLparAttributes = this.mCmdHelper.getLparAttributes(this.mLparIndexUInt16);
        UnsignedInt16 unsignedInt16 = fspLparAttributes.getClusterLparId();
        Vector vector = this.mLparObj.associatorNames(R50Define.AID_IBMHSC_LparInWLMCluster);
        RObject rObject = null;
        RObjectId rObjectId = null;
        if (vector != null && (object = vector.elements()).hasMoreElements()) {
            rObjectId = (RObjectId)object.nextElement();
            rObject = rObjectId.getObject();
            if (object.hasMoreElements()) {
                // empty if block
            }
        }
        if (unsignedInt16 == null) {
            if (rObjectId == null) {
                this.mLparObj.deleteAssociation(R50Define.AID_IBMHSC_LparInWLMCluster, rObjectId);
            }
        } else {
            if (rObjectId != null) {
                object = (String)rObject.getProperty(R50WLMCluster.Index_CollectionID);
                if (unsignedInt16.intValue() == Integer.parseInt((String)object)) {
                    return;
                }
                this.mLparObj.deleteAssociation(R50Define.AID_IBMHSC_LparInWLMCluster, rObjectId);
            }
            object = new RObjectId(1, R50Define.CID_IBMHSC_WLMCluster);
            ((RObjectId)object).setKeyValue(2, unsignedInt16.toString());
            ((RObjectId)object).setKeyValue(0, this.mCecMgr.getCecName());
            ((RObjectId)object).setKeyValue(1, "IBMHSC_ComputerSystem");
            RObject rObject2 = ((RObjectId)object).getObject();
            if (rObject2 == null) {
                System.out.println("[OM] creating new cluster for cec " + this.mCecMgr.getCecName());
                rObject2 = new RObject((RObjectId)object);
                rObject2.addInstance();
                rObject2.addAsso(R50Define.AID_IBMHSC_CompSysWLMCluster, this.mCecMgr.getObjectId());
                rObject2.addAsso(R50Define.AID_IBMHSC_LparInWLMCluster, this.mLparOid);
            } else {
                if (!rObject2.hasAssociation(R50Define.AID_IBMHSC_CompSysWLMCluster, this.mCecMgr.getObjectId())) {
                    rObject2.addAsso(R50Define.AID_IBMHSC_CompSysWLMCluster, this.mCecMgr.getObjectId());
                    System.out.println("[OM] WMLCluster added: " + unsignedInt16.toString());
                }
                if (!rObject2.hasAssociation(R50Define.AID_IBMHSC_LparInWLMCluster, this.mLparOid)) {
                    rObject2.addAsso(R50Define.AID_IBMHSC_LparInWLMCluster, this.mLparOid);
                    System.out.println("[OM] partition " + this.mLparName + " added into the cluster");
                }
            }
        }
    }

    public void updateLparIoPool() throws RException, PIHscServerException, PIHscCmdMgrException {
        Object[] objectArray;
        System.out.println("[OM] updateLparIoPool: " + this.mLparName);
        UnsignedInt16[] unsignedInt16Array = this.mCmdHelper.getLparIoPoolConfiguration(this.mLparIndexUInt16);
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < unsignedInt16Array.length; ++i) {
            System.out.println("ioPools[" + i + "]=" + unsignedInt16Array[i]);
            hashSet.add(String.valueOf(unsignedInt16Array[i]));
        }
        Vector vector = this.mLparObj.associatorNames(R50Define.AID_IBMHSC_LparInIOFailOverPool);
        System.out.println("ioPools in Repository: " + vector);
        RObject rObject = null;
        RObjectId rObjectId = null;
        if (vector != null) {
            objectArray = vector.elements();
            while (objectArray.hasMoreElements()) {
                rObjectId = (RObjectId)objectArray.nextElement();
                rObject = rObjectId.getObject();
                String string = (String)rObject.getProperty(R50IOFailOverPool.Index_CollectionID);
                System.out.println("ioPool: " + string);
                if (!hashSet.contains(string)) {
                    System.out.println("delete association: ioPool " + string + " on " + this.mLparName);
                    rObject.deleteAssociation(R50Define.AID_IBMHSC_LparInIOFailOverPool, this.mLparOid);
                    if (!rObject.hasAssociation(R50Define.AID_IBMHSC_LparInIOFailOverPool) && !rObject.hasAssociation(R50Define.AID_IBMHSC_SlotInIOFailOverPool)) {
                        System.out.println("delete ioPool: " + string);
                        rObject.deleteInstance();
                    }
                }
                hashSet.remove(string);
            }
        }
        objectArray = hashSet.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            String string = (String)objectArray[i];
            RObjectId rObjectId2 = new RObjectId(1, R50Define.CID_IBMHSC_IOFailOverPool);
            rObjectId2.setKeyValue(2, string);
            rObjectId2.setKeyValue(0, this.mCecMgr.getCecName());
            rObjectId2.setKeyValue(1, "IBMHSC_ComputerSystem");
            RObject rObject2 = rObjectId2.getObject();
            if (rObject2 == null) {
                System.out.println("[OM] creating new io failover pool: " + string + " for cec " + this.mCecMgr.getCecName());
                rObject2 = new RObject(rObjectId2);
                rObject2.addInstance();
                rObject2.addAsso(R50Define.AID_IBMHSC_CompSysIOFailOverPool, this.mCecMgr.getObjectId());
                rObject2.addAsso(R50Define.AID_IBMHSC_LparInIOFailOverPool, this.mLparOid);
                continue;
            }
            if (!rObject2.hasAssociation(R50Define.AID_IBMHSC_CompSysIOFailOverPool, this.mCecMgr.getObjectId())) {
                rObject2.addAsso(R50Define.AID_IBMHSC_CompSysIOFailOverPool, this.mCecMgr.getObjectId());
                System.out.println("[OM] IOFailOverPool added: " + string);
            }
            if (rObject2.hasAssociation(R50Define.AID_IBMHSC_LparInIOFailOverPool, this.mLparOid)) continue;
            rObject2.addAsso(R50Define.AID_IBMHSC_LparInIOFailOverPool, this.mLparOid);
            System.out.println("[OM] partition " + this.mLparName + " added into IOFailOverPool: " + string);
        }
    }

    public Object getProperty(String string) throws RException {
        return this.mLparObj.getProperty(string);
    }

    public boolean setProperty(int n, Object object) throws RException {
        return this.mLparObj.setProperty(n, object);
    }

    public boolean setProperty(String string, Object object) throws RException {
        return this.mLparObj.setProperty(string, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setPropertyWithLock(String string, Object object) throws RException {
        boolean bl = false;
        bl = this.setProperty(string, object);
        return bl;
    }

    public void sendModifiedIndication(RObject rObject) {
        this.mCecMgr.getIndMgr().sendIndication(4, this.mLparObj, rObject);
    }

    public boolean setLparState(int n) throws RException {
        boolean bl = false;
        if (this.setProperty("PartitionState", (Object)new UnsignedInt8((short)n))) {
            System.out.println("PartitionState = " + n);
            bl = true;
        }
        if ((n == 0 || n == 6 || n == 252) && this.setProperty("OpPanelValue", (Object)"")) {
            System.out.println("OpPanelValue be set to empty string");
            bl = true;
        }
        return bl;
    }

    public boolean updateServiceAuthority(boolean bl) throws RException {
        UnsignedInt16 unsignedInt16 = (UnsignedInt16)this.mCecMgr.getObject().getProperty(R50ComputerSystem.Index_ServPartID);
        boolean bl2 = false;
        if (unsignedInt16 != null && unsignedInt16.equals((Object)this.mLparIndexUInt16)) {
            bl2 = true;
        }
        boolean bl3 = false;
        RObject rObject = null;
        if (bl) {
            rObject = (RObject)this.mLparObj.clone();
        }
        if (this.mLparObj.setProperty(R50Partition.Index_ServiceAuthority, (Object)new Boolean(bl2))) {
            bl3 = true;
            System.out.println("lpar " + this.mLparIndexUInt16 + " ServiceAuthority=" + bl2);
            if (bl) {
                this.sendModifiedIndication(rObject);
            }
        }
        return bl3;
    }

    public void setDlparCapability(UnsignedInt32 unsignedInt32, UnsignedInt32 unsignedInt322) throws RException {
        boolean bl = false;
        RObject rObject = (RObject)this.mLparObj.clone();
        if (this.setProperty("DLPARCapabilities", (Object)unsignedInt32)) {
            bl = true;
        }
        if (this.setProperty("SysCmdCapabilities", (Object)unsignedInt322)) {
            bl = true;
        }
        if (bl) {
            this.sendModifiedIndication(rObject);
        }
    }
}

